/*
 *  ESFlashView.h
 *  Flash'In'App
 *
 *  Copyright 2008 Eltima Software. All rights reserved.
 *
 *	Flash'In'App is free for non-commercial use.
 *	If you plan to integrate it in commercial software, please, make sure you are acquainted with the license terms and obtain the Commercial License.
 *	Please, contact Eltima at sales@eltima.com or visit http://mac.eltima.com
 */

#ifndef __LP64__

#import <Cocoa/Cocoa.h>
#import "ESNetscapePluginView.h"

/*
 * playback quality constants
 */
typedef enum _FlashMovieQuality
{
  FlashMovieQuality_Low,
  FlashMovieQuality_Medium,
  FlashMovieQuality_High,
} FlashMovieQuality;

typedef struct _NPSignedRect
{
  int top;
  int left;
  int bottom;
  int right;
} NPSignedRect;

@interface ESFlashView : ESNetscapePluginView
{
  NPSignedRect currentRect, originalRect, maxRect;
  BOOL canDrag;
  BOOL inDrag;
  NSPoint dragPoint;

  BOOL mouseInView;
	BOOL allowNativeDrag;
  BOOL enableSecurity;
	
	void *jsRuntime;
	void *jsContext;
	void *jsGlobalObject;
  
  BOOL autoReadSWFInfo;
  int swfVersion;
  float frameRate;
}

/*
 * set/get path to the plugin
 * by default plugin will be loaded from Contents/PlugIns/Flash Player.plugin
 
 * pluginPath - returns current path to the plugin
 * setPluginPath: - sets the new value for this setting (cannot be nil and should point to existing path)
 */
+ (NSString *) pluginPath;
+ (void) setPluginPath:(NSString*)thePluginPath;

/*
 * turn FlashLocalSecurity on/off
 * must be called before loading movie
 * default and recommended value is "NO"

 * setEnabledSecurity: - sets the FlashLocalSecurity status to ON or OFF
 * isEnabledSecurity - returns current state of this setting
 */
- (void)setEnabledSecurity:(BOOL)value;
- (BOOL)isEnabledSecurity;

/*
 * allow/deny native dragging by plugin
 * zooming will be disabled, but flash components like sliders and scrolls will work

 * setAllowNativeDragg: - enables or disables handing dragging options by plugin
 * allowNativeDrag - returns current state of this setting
 */
- (void) setAllowNativeDrag:(BOOL)value;
- (BOOL) allowNativeDrag;

/*
 * globally allow/deny dragging by Flash'In'App, if it is enabled, allowNativeDrag setting will be ignored
 
 * canDrag - returns current state of this setting
 * setCanDrag: - enables or disables handling of dragging events by Flash'In'App

 *NOTE: this will work only if you correctly set current and original rects 
 */
- (BOOL) canDrag;
- (void) setCanDrag:(BOOL)value;

/*
 * functions to work with ZoomRect
 */
- (NPSignedRect) currentRect;
- (void) setCurrentRect:(NPSignedRect)rect;

- (NPSignedRect) originalRect;
- (void) setOriginalRect:(int32)left :(int32)top :(int32)right :(int32) bottom;

- (NPSignedRect) maxRect;

- (void) setOriginalSize:(BOOL)flag;
- (void) setFitSize;

- (void) zoomIn;
- (void) zoomOut;

- (void) setZoomPercent:(int)value;
- (int) zoomPercent;

- (void) displayRect:(NPSignedRect)rect;
- (void) displayZoomRect:(NSRect)rect;
- (void) updateCurrentRect;

/*
 * take movie snapshot in original size
 */
- (NSImage *) snapshotOriginalSize;

/*
 * scripting support
 
 * please, see the description of each method at Adobe's website: 
 * http://www.adobe.com/support/flash/publishexport/scriptingwithflash/scriptingwithflash_03.html
 */
- (BOOL) isPlaying;
- (void) play;
- (void) stopPlay;
- (int) totalFrames;
- (int) currentFrame;
- (void) gotoFrame:(int32)frame;
- (void) rewind;
- (void) back;
- (void) forward;
- (void) pan:(int32)x :(int32)y :(int32)panMode;
- (void) zoom:(int32)value;
- (void) setZoomRect:(int32)left :(int32)top :(int32)right :(int32) bottom;
- (FlashMovieQuality) flashQuality;
- (void) setFlashQuality:(FlashMovieQuality)value;

- (id) callFunction:(NSString *)value;

- (void) setVariable:(NSString *)name toValue:(id)value;
- (id) getVariable:(NSString *)name;

- (int) swfVersion;

- (float)frameRate;

@end

@interface NSObject (FlashPluginViewDelegate)
/*
 * this message will be sent to delegate when dragging is active

 * this is the method which you should use to realize dragging of the whole movie window when user drags it
 * (you can see the sample of how this works in our GUI sample)
 */
- (void) flashView:(ESFlashView *)flashView wasDraggedFrom:(NSPoint)fromPoint to:(NSPoint)toPoint;

/*
 * this message will be sent to delegate when movie calls an FSCommand
 * commandName - command name
 * arguments - arguments
 */
- (id) flashView:(ESFlashView *)flashView invokeFSCommand:(NSString *)commandName withArguments:(NSArray *)arguments;

/*
 * this is called with ExternalInterface.call
 * xmlString - function name and arguments are represented as <invoke name="asFunc"><arguments><string>Hello from Cocoa</string></arguments></invoke>
 */
- (id) flashView:(ESFlashView *)flashView callFunction:(NSString *)xmlString;

/*
 * This message will be sent to delegate when ESFlashView change visible rect of movie.
 */
- (void) flashView:(ESFlashView *)flashView didDisplayRect:(NPSignedRect)aDisplayedRect;
 
@end

#endif
